/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/


package cnrg.itx.datax;

import cnrg.itx.datax.devices.AudioProperty;
import cnrg.itx.datax.devices.NetworkProperty;

public class PropertiesNegotiation
{
	public static void main(String[] args) throws Exception
	{
		// Make a connection property
		ConnectionProperty cp = getConnectionCapabilities ();
		
		// Make two channel proprties collections
		cp.addChannelProperty (getInputChannelProperties ());
		cp.addChannelProperty (getOutputChannelProperties ());
		
		System.in.read ();
	}
	
	public static ConnectionProperty getConnectionCapabilities ()
	{
		// Make a connection property
		ConnectionProperty cp = new ConnectionProperty ();
		
		// Make two channel proprties collections
		cp.addChannelProperty (getInputChannelCapabilities ());
		cp.addChannelProperty (getOuputChannelCapabilities ());
		
		return cp;
	}
	
	public static ChannelProperty getInputChannelCapabilities ()
	{
		// Make the channel's properties collection
		ChannelProperty inChannel = new ChannelProperty (Channel.INPUT);
		
		// Make an audio property object and add it to the properties collection
		inChannel.addProperty (new AudioProperty (16000, 16, AudioProperty.PCM));
		inChannel.addProperty (new AudioProperty (16000, 8, AudioProperty.PCM));
		inChannel.addProperty (new AudioProperty (8000, 16, AudioProperty.PCM));
		inChannel.addProperty (new AudioProperty (8000, 8, AudioProperty.PCM));
		
		// Make an network property object and add it to the properties collection
		inChannel.addProperty (new NetworkProperty (9999));
		
		return inChannel;
	}
	
	public static ChannelProperty getOuputChannelCapabilities ()
	{
		// Make the channel's properties collection
		ChannelProperty outChannel = new ChannelProperty (Channel.INPUT);
		
		// Make an audio property object and add it to the properties collection
		outChannel.addProperty (new AudioProperty (16000, 16, AudioProperty.PCM));
		outChannel.addProperty (new AudioProperty (16000, 8, AudioProperty.PCM));
		outChannel.addProperty (new AudioProperty (8000, 16, AudioProperty.PCM));
		outChannel.addProperty (new AudioProperty (8000, 8, AudioProperty.PCM));
		
		// Make an network property object and add it to the properties collection
		outChannel.addProperty (new NetworkProperty (9999));
		
		return outChannel;
	}
	
	public static ChannelProperty getInputChannelProperties ()
	{
		// Make the channel's properties collection
		ChannelProperty inChannel = new ChannelProperty (Channel.INPUT);
		
		// Make an audio property object and add it to the properties collection
		inChannel.addProperty (new AudioProperty (8000, 8, AudioProperty.PCM));
		
		// Make an network property object and add it to the properties collection
		inChannel.addProperty (new NetworkProperty (9999));
		
		return inChannel;
	}
	
	public static ChannelProperty getOutputChannelProperties ()
	{
		// Make the channel's properties collection
		ChannelProperty outChannel = new ChannelProperty (Channel.OUTPUT);
		
		// Make an audio property object and add it to the properties collection
		outChannel.addProperty (new AudioProperty (8000, 8, AudioProperty.PCM));
		
		// Make an network property object and add it to the properties collection
		outChannel.addProperty (new NetworkProperty (9999));
		
		return outChannel;
	}
}
